program hill;

{$IFDEF FPC}
  {$mode DELPHI}
{$ENDIF}

uses
  Classes, sysutils, typinfo, getopts, math;

Type
  TComponent  = (vX,vY);
  TPoint      = array[TComponent] of Real;

Const
  RANGE  : TPoint = ( 100, 100 );
  TOP    : TPoint = (  57,  42 );
  SCALING = 2.0;

function parseComponent( line: string; var point: TPoint ):boolean;
var
  idx     : Integer;
  tmp     : String;
  val     : Real;
begin
  result  := false;

  idx     := pos( ' ', line );

  if idx <= 0
    then exit;

  tmp     := Copy( line, idx, length( line )-idx+1 );
  val     := StrToFloat( trim( tmp ) );

  line    := trim( copy( line, 1, idx ) );

  if length( line ) <> 1
    then exit;

  case line[1] of
    'x': point[vX]  := val;
    'y': point[vY]  := val;
    else exit;
  end;

  result  := true;
end;

function parsePoint( const list: TStringList ):TPoint;
var
  idx     : Integer;
begin
  if list.Count <> length(TPoint)
    then exit;

  for idx := 0 to list.Count-1 do
    begin
      parseComponent( list.Strings[idx], result );
    end;
end;

function calcFitness( const point: TPoint ):real;
var
  idx           : TComponent;
begin
  result        := 0;

  for idx := low(point) to High(point) do
    begin
      result   := result + sqr( abs( point[idx] - TOP[idx] ) / RANGE[idx] );
    end;

  result       := sqrt( result );
  result       := result * SCALING;
  result       := 1 - result;
  result       := max( result, 0 );
end;

var
  filein, fileout   : String;
  c                 : char;
  parameter         : TStringList;
  fitness           : Real;
  point             : TPoint;

begin
  c:=#0;
  repeat
    c := GetOpt( 'i:o:' );
    case c of
      'i' : filein  := OptArg;
      'o' : fileout := OptArg;
    end;
 until c=endofoptions;

  parameter  := TStringList.Create;
  parameter.LoadFromFile( filein );
  point     := parsePoint( parameter );
  FreeAndNil( parameter );

  fitness    := calcFitness( point );

  parameter  := TStringList.Create;
  parameter.Append( 'fitness ' + FloatToStr( fitness ) );
  parameter.SaveToFile( fileout );
  parameter.Free;
end.

