/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * @file Experimenter.h
 *
 * @brief Header of the Experimenter.
 */

#ifndef EXPERIMENTER_H_
#define EXPERIMENTER_H_

#include  <time.h>
#include <string>
#include "Experiments/Experiment.h"
#include "common/include/types.h"
#include "DataLogger/DataLogger.h"
#include  "Experiments/ExperimentLoader.h"
#include  "Experiments/Algorithms/AlgorithmExperimentLoader.h"
#include  "Experiments/Simulators/SimulationExperimentLoader.h"
#include  "Experiments/Array/ArrayExperimentLoader.h"
#include  "Experiments/Algorithms/Evolutionary/EvolutionaryAlgorithmLoader.h"
#include  "Experiments/Algorithms/SimulatedAnnealing/SimulatedAnnealingAlgorithmLoader.h"
#include  "Experiments/Algorithms/Systematic/SystematicAlgorithmLoader.h"
#include  "Experiments/Algorithms/TextbookSa/TextbookSaAlgorithmLoader.h"

using namespace std;


/**
 * @class Experimenter
 * @brief The Experimenter sets up and conducts the experiments.
 *
 * The Experimenter sets up the environment for the experiments like the
 * DataLogger and so on. It starts the series of experiments by starting
 * the root experiment.
 *
 * @author Nicolas Rüegg, Urs Fässler
 */
class Experimenter {
private:
	/// The DataLogger for this series of experiments.
	DataLogger::DataLogger*  m_log;
	/// The ExperimentLoader which is used to load the experiments.
	ExperimentLoader         m_experimentLoader;
	/// The root experiment.
	Experiment*              m_experiment;

	void initLoader();
	void loadConfig( string& configFile );

public:

	Experimenter( string& configFile, string& logFile, int loglevel );
	virtual ~Experimenter();

	double run( Directory path );
};

#endif /* EXPERIMENTER_H_ */
