/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ALGORITHMEXPERIMENT_H_
#define ALGORITHMEXPERIMENT_H_

#include  "../../common/paramutils.h"
#include  "Algorithm.h"
#include  "../Experiment.h"

/**
 * How sub experiments uses new parameter values.
 */
typedef enum
{
  PM_ABSOLUTE,    /** Override values */
  PM_RELATIVE     /** Sum new and old values */
} ParamMode;

/**
 * Configuration of one parameter.
 */
typedef struct
{
  double      min;
  double      max;
  ParamMode   mode;
} ParamConfig;

/**
 * Configuration of one value.
 */
typedef struct
{
  double      value;
  ParamMode   mode;
} ValueConfig;

/**
 * @class AlgorithmExperiment
 * @brief Executes a algorithm experiment
 * @see Algorithm
 */
class AlgorithmExperiment: public Experiment
{
  private:
    Algorithm*                      m_algorithm;
    Experiment*                     m_experiment;

    /** Parameter which are changed from Algorithm */
    const map<string,ParamConfig>*  m_changeable;

    /** Parameter which are fixed to a value */
    const map<string,ValueConfig>*  m_fixed;

    map<string,double> merge( const map<string,double>& base, const map<string,double>& additional ) const;
    map<string,double> merge( const map<string,double>& base, const map<string,double>& additional,  const map<string,ParamConfig>& mode ) const;
    MapParameterToValueT makeMap( const map<string,ValueConfig>& values ) const;
    MapParameterToRangeT makeRange( const map<string,ParamConfig>& in ) const;

  protected:
    string getName() const;

  public:
    AlgorithmExperiment
    (
      Algorithm*                        algorithm,
      Experiment*                       experiment,
      const map<string,ParamConfig>*    changeable,
      const map<string,ValueConfig>*    fixed,
      FitnessCalculation                fitness,
      DataLogger::DataLogger*           log
    );

    double run( const MapParameterToValueT* value, Directory path );

};


#endif /* ALGORITHMEXPERIMENT_H_ */
