/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ALGORITHMEXPERIMENTLOADER_H_
#define ALGORITHMEXPERIMENTLOADER_H_

#include  <libxml++/libxml++.h>
#include  <libxml++/nodes/node.h>

#include  "../ExperimentLoader.h"
#include  "AlgorithmLoader.h"
#include  "AlgorithmExperiment.h"

/**
 * @class AlgorithmExperimentLoader
 * @brief Creates a algorithm experiment from a xml node.
 *
 * The AlgorithmLoader has to be added to this loader. They are freed
 * when the destructor of this class is called.
 *
 * @see AlgorithmLoader
 */
class AlgorithmExperimentLoader: public AbstractExperimentLoader
{
  private:
    map<string,const AlgorithmLoader*>     m_algorithm;

    ParamMode strToMode( string in ) const;
    void readParam( const xmlpp::Node* node, map<string,ParamConfig>* map ) const;
    void readFixed( const xmlpp::Node* node, map<string,ValueConfig>* map ) const;
    void readParamsChangeable( const xmlpp::Node* node, map<string,ParamConfig>* changeable ) const;
    void readParamsFixed( const xmlpp::Node* node, map<string,ValueConfig>* fixed ) const;

    Algorithm* loadAlgorithm( const xmlpp::Element* experiment ) const;
    map<string,ParamConfig>* loadChangeable( const xmlpp::Element* experiment ) const;
    map<string,ValueConfig>* loadFixed( const xmlpp::Element* experiment ) const;

  public:
    ~AlgorithmExperimentLoader();

    Experiment* createExperiment( const xmlpp::Element* experiment ) const;

    void add( string name, const AlgorithmLoader* loader );
    const AlgorithmLoader* get( string name ) const;
};

#endif /* ALGORITHMEXPERIMENTLOADER_H_ */
