/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ALGORITHMLOADER_H_
#define ALGORITHMLOADER_H_


#include  <string>
#include  <list>
#include  <iterator>
#include  <libxml++/libxml++.h>

#include  "../LoaderException.h"
#include  "Algorithm.h"

using namespace std;

/**
 * @class AlgorithmLoader
 * @brief Base class for all algorithm loaders
 */
class AlgorithmLoader
{
  private:
    DataLogger::DataLogger* m_log;

  public:
    AlgorithmLoader( DataLogger::DataLogger* log );

    DataLogger::DataLogger* getLogger() const;

    /**
     * Returns the xml namespace of the configuration for the specific algorithm.
     * @return
     */
    virtual string getNamespace() const = 0;

    /**
     * Creates and returns a algorithm from the configuration.
     * @param experiment
     * @return
     */
    virtual Algorithm* load( const xmlpp::Element* experiment ) const = 0;
};


#endif /* ALGORITHMLOADER_H_ */
