/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef EVOLUTIONARYALGORITHMLOADER_H_
#define EVOLUTIONARYALGORITHMLOADER_H_

#include  "../AlgorithmLoader.h"
#include  "EvolutionaryAlgorithm.h"
#include  "../../../common/convert.h"

/**
 * Helper struct for parameter.
 */
typedef struct
{
  int                         numberOfParents;
  int                         numberOfGenerations ;
  int                         populationSize;
  bool                        elitismOn;
  double                      changeProbability;
  ParentSelectionAlgorithmT   parentSelection;
  Distribution                distribution;
  double                      parameterScaling;
} EvolutionaryParam;

/**
 * @class EvolutionaryAlgorithmLoader
 * @brief Loader for evolution algorithm
 * @see AlgorithmLoader
 */
class EvolutionaryAlgorithmLoader: public AlgorithmLoader
{
  private:
    void initDefaultParam( EvolutionaryParam* param ) const;
    void loadParam( const xmlpp::Element* config, EvolutionaryParam* param ) const;
    const xmlpp::Element* getParamSection( const xmlpp::Element* experiment ) const;

  public:
    EvolutionaryAlgorithmLoader( DataLogger::DataLogger* log );

    string getNamespace() const;
    Algorithm* load( const xmlpp::Element* experiment ) const;
};

#endif /* EVOLUTIONARYALGORITHMLOADER_H_ */
