/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/


#include  "SimulatedAnnealingAlgorithmLoader.h"

/**
 * @see AlgorithmLoader
 * @param log
 * @return
 */
SimulatedAnnealingAlgorithmLoader::SimulatedAnnealingAlgorithmLoader( DataLogger::DataLogger* log ):AlgorithmLoader::AlgorithmLoader( log )
{
}

/**
 * @see AlgorithmLoader
 * @return
 */
string SimulatedAnnealingAlgorithmLoader::getNamespace() const
{
  return  "http://ailab.ifi.uzh.ch/testframework/2008/algorithm/simulatedannealing/";
}

/**
 * @see AlgorithmLoader
 * @param experiment
 * @return
 */
Algorithm* SimulatedAnnealingAlgorithmLoader::load( const xmlpp::Element* experiment ) const
{
  SimanLoaderParam   param;

  loadParam( getConfigSection( experiment ), &param );

  return  new SimulatedAnnealingAlgorithm
  (
      param.initTemperature,
      param.terminateTemperature,
      param.cooling,
      param.bestFitness,
      param.boltzmannConstant,
      param.parameterScaling,
      getLogger()
  );
}

/**
 * Loads and returns the parameter for the algorithm.
 * @param config configuration node
 * @param param parsed parameter
 */
void SimulatedAnnealingAlgorithmLoader::loadParam( const xmlpp::Element* config, SimanLoaderParam* param ) const
{
  if( config == NULL )
  {
    throw new LoaderException( "Simulated Annealing needs parameter" );
  }

  param->bestFitness            = strToFloat( config->get_attribute_value( "bestfitness", "" ) );
  param->cooling                = strToFloat( config->get_attribute_value( "cooling", "" ) );
  param->initTemperature        = strToFloat( config->get_attribute_value( "inittemperature", "" ) );
  param->terminateTemperature   = strToFloat( config->get_attribute_value( "terminatetemperature" ) );

  xmlpp::Attribute*   attr;

  attr    = config->get_attribute( "boltzmannconstant", "" );
  if( attr == NULL )
  {
    param->boltzmannConstant  = 1;
  }
  else
  {
    param->boltzmannConstant  = strToFloat( attr->get_value() );
  }

  attr    = config->get_attribute( "parameterscaling", "" );
  if( attr == NULL )
  {
    param->parameterScaling  = 1;
//    param->parameterScaling  = param->initTemperature;
  }
  else
  {
    param->parameterScaling  = strToFloat( attr->get_value() );
  }
}

/**
 * Returns the configuration node.
 * @param experiment
 * @return
 */
const xmlpp::Element* SimulatedAnnealingAlgorithmLoader::getConfigSection( const xmlpp::Element* experiment ) const
{
  xmlpp::Node::NodeList nodes;
  xmlpp::Node::NodeList::iterator itr;

  nodes = experiment->get_children( "" );

  for( itr = nodes.begin(); itr != nodes.end(); itr++ )
  {
    if( ((*itr)->get_name() == "config") && ((*itr)->get_namespace_uri() == getNamespace()) )
    {
      return dynamic_cast<xmlpp::Element*> ( *itr );
    }
  }

  return NULL;
}

