/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef SIMULATEDANNEALINGALGORITHMLOADER_H_
#define SIMULATEDANNEALINGALGORITHMLOADER_H_

#include  "../AlgorithmLoader.h"
#include  "SimulatedAnnealingAlgorithm.h"
#include  "../../../common/convert.h"

/**
 * Helper struct for handling parameters.
 */
typedef struct
{
  double                  initTemperature;
  double                  terminateTemperature;
  double                  cooling;
  double                  bestFitness;
  double                  boltzmannConstant;
  double                  parameterScaling;
} SimanLoaderParam;

/**
 * @class SimulatedAnnealingAlgorithmLoader
 * @brief Loader for simulated annealing algorithm.
 */
class SimulatedAnnealingAlgorithmLoader: public AlgorithmLoader
{
  public:
    void loadParam( const xmlpp::Element* config, SimanLoaderParam* param ) const;
    const xmlpp::Element* getConfigSection( const xmlpp::Element* experiment ) const;

  public:
    SimulatedAnnealingAlgorithmLoader( DataLogger::DataLogger* log );

    string getNamespace() const;
    Algorithm* load( const xmlpp::Element* experiment ) const;
};

#endif /* SIMULATEDANNEALINGALGORITHMLOADER_H_ */
