/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * @file SystematicAlgorithm.h
 *
 * @brief Header of the SystematicAlgorithm.
 */

#ifndef SYSTEMATICALGORITHM_H_
#define SYSTEMATICALGORITHM_H_

#include  "../Algorithm.h"
#include  "../../../common/include/types.h"
#include  "../../../DataLogger/DataLogger.h"
#include  "../../../common/convert.h"

using namespace std;

/**
 * Configuration to a parameter.
 */
typedef struct
{
  RangeS    range;
  int       stepCount;
  int       step;
} SystematicParameter;

/**
 * @class SystematicAlgorithm
 * @brief SystematicAlgorithm implements a systematic algorithm.
 *
 * The Systematic Algorithm creates every possible combination of the parameter values.
 *
 * @author Nicolas Rüegg, Urs Fässler
 *
 * @see Experiment
 * @see Algorithm
 * @see DataLogger
 */
class SystematicAlgorithm: public Algorithm
{
  private:
	/// Map of parameters and the their configuration.
    map<string,SystematicParameter>   m_params;
    /// True if every possible combination has been created.
    bool                              m_endReached;

    /// DataLogger to use for output.
    DataLogger::DataLogger*           m_log;
    /// Fitness of the current set of parameters.
    double                            m_fitness;
    /// Number of the current step.
    int                               m_step;

    double calcValue( const SystematicParameter& param ) const;

  public:
    SystematicAlgorithm( const map<string,int>* steps, DataLogger::DataLogger* log );
    virtual ~SystematicAlgorithm();

    void initialize( const MapParameterToRangeT* changeable );
    void fitnessFeedback( double fitness );
    bool hasNext() const;
    MapParameterToValueT next();
    void extendDirectory( Directory& dir ) const;
    string getName() const;

};

#endif /* SYSTEMATICALGORITHM_H_ */
