/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

#include  "SystematicAlgorithmLoader.h"

/**
 * @see AlgorithmLoader
 * @param log
 * @return
 */
SystematicAlgorithmLoader::SystematicAlgorithmLoader( DataLogger::DataLogger* log ):AlgorithmLoader::AlgorithmLoader( log )
{

}

/**
 * @see AlgorithmLoader
 * @return
 */
string SystematicAlgorithmLoader::getNamespace() const
{
  return  "http://ailab.ifi.uzh.ch/testframework/2008/algorithm/systematic/";
}

/**
 * @see AlgorithmLoader
 * @param experiment
 * @return
 */
Algorithm* SystematicAlgorithmLoader::load( const xmlpp::Element* experiment ) const
{
  map<string,int>       steps;
  int                   stepcount;

  stepcount     = getStepPerParameter( experiment );
  readParams( getParamSection( experiment ), &steps, stepcount );

  return  new SystematicAlgorithm( &steps, getLogger() );
}

/**
 * Reads the default stepsize.
 * @param experiment
 * @return
 */
int SystematicAlgorithmLoader::getStepPerParameter( const xmlpp::Element* experiment ) const
{
  xmlpp::Node::NodeList               nodes;
  xmlpp::Node::NodeList::iterator     itr;

  nodes = experiment->get_children( "" );

  for( itr = nodes.begin(); itr != nodes.end(); itr++ )
  {
    if( ((*itr)->get_name() == "config") && ((*itr)->get_namespace_uri() == getNamespace()) )
    {
      return  strToInt( (dynamic_cast<xmlpp::Element*> ( *itr ) )->get_attribute_value( "stepsperparameter", "" ) );
    }
  }

  return 1;
}

/**
 * Reads the stepsize of one parameter.
 * @param config
 * @param steps
 * @param stepcount
 */
void SystematicAlgorithmLoader::loadStepcount( const xmlpp::Element* config, map<string,int>* steps, int stepcount ) const
{
  xmlpp::Element::AttributeList::const_iterator   itr;
  xmlpp::Element::AttributeList                   attrList;
  string                    name;

  name  = config->get_attribute_value( "name", "" );

  attrList  = config->get_attributes();

  for( itr = attrList.begin(); itr != attrList.end(); itr++ )
  {
    if( ((*itr)->get_name() == "steps") && ((*itr)->get_namespace_uri() == getNamespace() ) )
    {
      (*steps)[name]  = strToInt( (*itr)->get_value() );
      return;
    }
  }

  (*steps)[name]  = stepcount;
}

/**
 * Reads the stepsize of all parameters.
 * @param config
 * @param steps
 * @param stepcount
 */
void SystematicAlgorithmLoader::readParams( const xmlpp::Element* config, map<string,int>* steps, int stepcount ) const
{
  xmlpp::Node::NodeList             nodes   = config->get_children( "param" );
  xmlpp::Node::NodeList::iterator   itr;

  for( itr = nodes.begin(); itr != nodes.end(); itr++ )
  {
    loadStepcount( dynamic_cast<xmlpp::Element*>( *itr ), steps, stepcount );
  }
}

/**
 * Returns the node of the parameters.
 * @param experiment
 * @return
 */
const xmlpp::Element* SystematicAlgorithmLoader::getParamSection( const xmlpp::Element* experiment ) const
{
  xmlpp::Node::NodeList             nodes   = experiment->get_children( "parameters" );

  if( nodes.size() == 1 )
  {
    return  dynamic_cast<const xmlpp::Element*> ( *nodes.begin() );
  }

  throw new LoaderException( "no param found by systematic algorithm" );
}
