/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SYSTEMATICALGORITHMLOADER_H_
#define SYSTEMATICALGORITHMLOADER_H_

#include  "libxml++/attribute.h"
#include  "../AlgorithmLoader.h"
#include  "../../../common/convert.h"
#include  "SystematicAlgorithm.h"

/**
 * @class SystematicAlgorithmLoader
 * @brief loader for the systematic algorithm
 */
class SystematicAlgorithmLoader: public AlgorithmLoader
{
  private:
    int getStepPerParameter( const xmlpp::Element* experiment ) const;
    void readParams( const xmlpp::Element* config, map<string,int>* steps, int stepcount ) const;
    void loadStepcount( const xmlpp::Element* config, map<string,int>* steps, int stepcount ) const;
    const xmlpp::Element* getParamSection( const xmlpp::Element* experiment ) const;

  public:
    SystematicAlgorithmLoader( DataLogger::DataLogger* log );

    string getNamespace() const;
    Algorithm* load( const xmlpp::Element* experiment ) const;
};

#endif /* SYSTEMATICALGORITHMLOADER_H_ */
