/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef TEXTBOOKSA_H_
#define TEXTBOOKSA_H_

#include  <cmath>
#include  <string>
#include  <list>
#include  <gsl/gsl_rng.h>
#include  <gsl/gsl_randist.h>

#include  "../Algorithm.h"
#include  "../../../common/paramutils.h"
#include  "../../../common/convert.h"

using namespace std;

#define   TSA_OLDNGOOD    0
#define   TSA_NEW         1

/**
 * Helper struct for TextbookSaAlgorithm
 */
typedef struct
{
  double      min;
  double      max;
  double      value[2];
  string      name;
} TextbookSaParameter;

/**
 * @class TextbookSaAlgorithm
 * @brief a classical simulated annealing algorithm
 */
class TextbookSaAlgorithm: public Algorithm
{
  private:
    double                    m_initTemperature;
    double                    m_terminateTemperature;
    double                    m_cooling;
    double                    m_bestFitness;

    double                    m_temperature;
    double                    m_errorOfOldNGood;
    list<TextbookSaParameter> m_param;
    int                       m_step;

    gsl_rng*                  m_randomGenerator;

    void newParameter( TextbookSaParameter* param, double scaling ) const;
    void newParameters( double scaling );
    void createParamsFromRange( const MapParameterToRangeT* range );
    void useNewValues();

    void initRandomGenerator( void );
    void freeRandomGenerator();

  public:
    TextbookSaAlgorithm( double initTemperature, double terminateTemperature, double cooling, double bestFitness, DataLogger::DataLogger* log );
    ~TextbookSaAlgorithm();

    void initialize( const MapParameterToRangeT* changeable );
    void fitnessFeedback( double fitness );
    bool hasNext() const;
    MapParameterToValueT next();
    void extendDirectory( Directory& dir ) const;

    string getName() const;
};

#endif /* TEXTBOOKSA_H_ */
