/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

#include  "ArrayExperiment.h"


/**
 * The constructor.
 *
 * Sets the members.
 * Prepares the ArrayExperiment for execution.
 *
 * @param array		List of the sub-experiments the ArrayExperiment contains.
 * @param fitness	Method to calculate the fitness value
 * @param log		DataLogger to use for data output.
 *
 * @see ExperimentArrayFitness
 */
ArrayExperiment::ArrayExperiment( list<Experiment*>* array, FitnessCalculation fitness, DataLogger::DataLogger *log ): Experiment::Experiment( fitness, log )
{
  m_array           = array;
}

/**
 * Executes the sub-experiments and returns the specified combination of their fitness values.
 * @param parameterValues	Set of parameter values.
 * @param path				Directory where the results are put.
 * @return	Combined fitness value.
 */
double ArrayExperiment::run( const MapParameterToValueT* parameterValues, Directory path )
{
  list<Experiment*>::iterator     itr;
  int                             index;

  index   = 0;

  for( itr = m_array->begin(); itr != m_array->end(); itr++ )
  {
    Directory   subdir( path );

    subdir.addSubdirectory( "array" + intToStr( index ) );

    addFitness( (*itr)->run( parameterValues, subdir ), parameterValues );
    index++;
  }

  return  exitExperiment();
}

/**
 * @return
 */
string ArrayExperiment::getName() const
{
  return  "array";
}
