/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * @file ArrayExperiment.h
 *
 * @brief Header of the ArrayExperiment.
 */

#ifndef ARRAYEXPERIMENT_H_
#define ARRAYEXPERIMENT_H_

#include  <string>
#include  <list>
#include  "../Experiment.h"
#include  "../../DataLogger/DataLogger.h"
#include  "../../common/convert.h"

using namespace std;

/**
 * @class ArrayExperiment
 * @brief Contains experiments on the same level and returns a fitness value computed from the individual fitness values.
 *
 * An ArrayExperiment contains several other experiments on the sane level. The fitness value it returns is a
 * combination of the sub-experiments fitness values.
 *
 * @author Urs Fässler, Nicolas Rüegg
 * @see Experiment
 * @see ExperimentArrayFitness
 */
class ArrayExperiment: public Experiment
{
  private:
	/// Experiments the array contains.
    list<Experiment*>*      m_array;
    /// Method to calculate the fitness value.
    ExperimentFitness       m_fitnessFunction;

    double calculateFitness( const list<double>* values ) const;

  protected:
    string getName() const;

  public:
    ArrayExperiment( list<Experiment*>* array, FitnessCalculation fitness, DataLogger::DataLogger *log );
    ~ArrayExperiment();

    double run( const MapParameterToValueT* parameterValues, Directory path );

};

#endif /* EXPERIMENTARRAY_H_ */
