/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

#include  "ArrayExperimentLoader.h"

/**
 * @return
 */
ArrayExperimentLoader::ArrayExperimentLoader()
{
}

/**
 * Read and parse the fitness calculation function. A LoaderException is throw
 * if a error occurs.
 * @param array
 * @return
 */
/*ExperimentArrayFitness ArrayExperimentLoader::readFitness( const xmlpp::Element* array ) const
{
  string                                              fitness;
  map<string,ExperimentArrayFitness>::const_iterator  idx;

  fitness   = array->get_attribute_value( "fitness", "" );
  idx       = m_EF_NAME.find( fitness );
  if( idx == m_EF_NAME.end() )
  {
    throw new LoaderException( "unknown fitness function" );
  }
  return  idx->second;
}*/

/**
 * Reads all configuration parameter.
 * @param array
 * @return
 */
/*ArrayExperimentParameter ArrayExperimentLoader::loadParams( const xmlpp::Element* array ) const
{
  ArrayExperimentParameter    result;

  result.fitness   = readFitness( array );

  return  result;
}*/

/**
 * Loads all child experiments.
 * @param array
 * @return
 */
list<Experiment*>* ArrayExperimentLoader::loadElements( const xmlpp::Element* array ) const
{
  list<Experiment*>*                      result;
  xmlpp::Node::NodeList::const_iterator   itr;
  xmlpp::Node::NodeList                   nodes;

  result    = new list<Experiment*>();

  nodes   = array->get_children( "" );

  for( itr = nodes.begin(); itr != nodes.end(); itr++ )
  {
    const xmlpp::Element*   elem = dynamic_cast<const xmlpp::Element*>(*itr);

    if( elem != NULL )
    {
      result->push_back( getLoader()->createExperiment( elem ) );
    }
  }

  return  result;
}

/**
 * Create and return a new ArrayExperiment from xml node.
 * @param array
 * @return
 */
ArrayExperiment* ArrayExperimentLoader::createExperiment( const xmlpp::Element* array ) const
{
  FitnessCalculation    fitness;

  fitness   = readFitness( array );
  return  new ArrayExperiment( loadElements( array ), fitness, getLoader()->getLogger() );
}
