/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ARRAYEXPERIMENTLOADER_H_
#define ARRAYEXPERIMENTLOADER_H_

#include  <libxml++/libxml++.h>
#include  <libxml++/nodes/node.h>

#include  "../LoaderException.h"
#include  "../ExperimentLoader.h"
#include  "ArrayExperiment.h"

/**
 * @class ArrayExperimentLoader
 * @brief Creates a ArrayExperiment from a configuration node
 * @see ArrayExperiment
 */
class ArrayExperimentLoader: public AbstractExperimentLoader
{
  private:
//    ArrayExperimentParameter loadParams( const xmlpp::Element* array ) const;
    list<Experiment*>* loadElements( const xmlpp::Element* array ) const;

  public:
    ArrayExperiment* createExperiment( const xmlpp::Element* array ) const;

    ArrayExperimentLoader();

};

#endif /* EXPERIMENTARRAYLOADER_H_ */
