/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef EXPERIMENT_H_
#define EXPERIMENT_H_

#include  <string>
#include  <cmath>
#include  <limits>
#include  "LoaderException.h"
#include  "../common/include/types.h"
#include  "../DataLogger/DataLogger.h"
#include  "../common/Directory.h"
#include  "../common/paramutils.h"

/**
 * Types how the fitness value is calculated out of the sub experiments.
 */
typedef enum
{
  FC_AVERAGE,
  FC_MINIMUM,
  FC_MAXIMUM,
  FC_PRODUCT,
  FC_INVERSEPRODUCT,
  FC_SUM
} FitnessCalculation;

typedef struct
{
  double    min;
  double    max;
  double    sum;
  double    product;
  int       count;
  MapParameterToValueT  map;
} ExperimentFitness;

/**
 * @class Experiment
 * @brief Base class for all experiments.
 */
class Experiment
{
  protected:
	  DataLogger::DataLogger*  m_log;
	  ExperimentFitness        m_fitness;
	  FitnessCalculation       m_fitnessType;
	  Directory                m_directory;
	  void writeResult( string filename, double fitness ) const;
	  void writeMap( string filename ) const;

	  void addFitness( double fitness, const MapParameterToValueT* values );
	  double exitExperiment();

	  virtual string getName() const = 0;

  public:
    Experiment( FitnessCalculation fitness, DataLogger::DataLogger* log );

    /**
     * Execute the experiment with this values in that directory.
     * @param parameterValues
     * @param path
     * @return
     */
	  virtual double run( const MapParameterToValueT* parameterValues, Directory path ) = 0;

	  DataLogger::DataLogger* getLogger();

    static FitnessCalculation parseFitnessCalculation( string value );
    static string serializeFitnessCalculation( FitnessCalculation calculation );
};

#endif /* EXPERIMENT_H_ */
