/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * @file SimulationExperiment.h
 *
 * @brief Header of the SimulationExperiment.
 */

#ifndef SIMULATIONEXPERIMENT_H_
#define SIMULATIONEXPERIMENT_H_

#include  <iostream>
#include  <cstdlib>
#include  "../../common/paramutils.h"
#include  "../Experiment.h"

/**
 * @class SimulationExperiment
 * @brief SimulationExperiment calls an external simulation software and returns its results.
 *
 * A SimulationExperiment calls an external simulation software by executing
 * [simulationProgram] -i [INPUTFILE] -o [OUTPUTFILE]
 * and returns its results to the calling Experiment.
 *
 * @author Urs Fässler, Nicolas Rüegg
 * @see Experiment
 */
class SimulationExperiment: public Experiment
{
  private:
	/// Path to the simulation program to call.
    string            m_program;
    /// Arguments to the simulation program.
    string            m_argument;

    double getFitness( const map<string,double>* result ) const;

  protected:
    string getName() const;

  public:
    SimulationExperiment( string program, string argument, FitnessCalculation fitness, DataLogger::DataLogger* log );
    virtual ~SimulationExperiment();

    double run( const MapParameterToValueT* parameterValues, Directory path );
};

#endif /* SIMULATION_H_ */
