/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

#include  "SimulationExperimentLoader.h"

/**
 * Returns the simulation experiment specified by "experiment".
 * A LoaderException is thrown if a error occurs.
 * @param experiment
 * @return
 */
SimulationExperiment* SimulationExperimentLoader::createExperiment( const xmlpp::Element* experiment ) const
{
  string  program;
  string  argument;

  program   = experiment->get_attribute_value( "program", "" );
  argument  = experiment->get_attribute_value( "argument", "" );

  if( program == "" )
  {
    throw new LoaderException( "SimulationExperimentLoader: no program specified" );
  }

  return  new SimulationExperiment( program, argument, FC_AVERAGE, getLoader()->getLogger() );
}
