/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/


#include  "Directory.h"

Directory::Directory()
{
}

/**
 *
 * @param isRelative relative path
 * @return
 */
Directory::Directory( bool isRelative )
{
  m_relativePath  = isRelative;
}

/**
 *
 * @param dir
 * @param includesFilename last entry is a filename
 * @return
 */
Directory::Directory( string dir, bool includesFilename )
{
  m_includesFilename  = includesFilename;
  parseDir( dir );
}

/**
 * Breaks a directory string into the single directories. The new dir is used.
 * @param dir
 */
void Directory::parseDir( string dir )
{
  unsigned int   start;
  unsigned int   ende;

  m_dir.clear();

  if( dir.substr( 0, 1 ) == "/" )
  {
    m_relativePath  = false;
    start = 1;
  }
  else
  {
    m_relativePath  = true;
    if( dir.substr( 0, 2 ) == "./" )
    {
      start = 2;
    }
    else
    {
      start = 0;
    }
  }

  ende  = start;

  while( ende < dir.size() )
  {
    ende  = dir.find( "/", start );

    if( ende == (unsigned int)string::npos )
    {
      if( start < dir.size() )
      {
        m_dir.push_back( dir.substr( start, dir.size()-start ) );
      }
      break;
    }

    if( ende == start )
    {
      break;
    }

    m_dir.push_back( dir.substr( start, ende-start ) );

    start = ende+1;
  }
}

/**
 * Creates the directory on the disk.
 */
void Directory::createDirectory() const
{
  list<string>::const_iterator    itr;
  list<string>::const_iterator    last;
  string                          path;

  if( m_relativePath )
  {
    path  = ".";
  }

  last  = m_dir.end();
  if( m_includesFilename )
  {
    last--;
  }

  for( itr = m_dir.begin(); itr != last; itr++ )
  {
    appendDirectory( path, itr );
    mkdir( path.c_str(), S_ISUID | S_ISGID | 0x1FF );
  }
}

/**
 * Returns the directory as String.
 * @return
 */
string Directory::getDirectory() const
{
  list<string>::const_iterator    itr;
  string                          path;

  if( m_relativePath )
  {
    path  = ".";
  }

  for( itr = m_dir.begin(); itr != m_dir.end(); itr++ )
  {
    appendDirectory( path, itr );
  }

  return  path;
}

/**
 * Helper function to create a string with the direcoty.
 * @param path
 * @param dir
 */
void Directory::appendDirectory( string& path, list<string>::const_iterator& dir ) const
{
  path  = path + "/" + *dir;
}

/**
 * Returns the directory as a String list.
 * @return
 */
const list<string> Directory::getBrokenDirectory() const
{
  return  m_dir;
}

/**
 * Adds a directory
 * @param name
 */
void Directory::addSubdirectory( string name )
{
  m_dir.push_back( name );
}

/**
 * Returns true if the last entry is a filename
 * @param doInclude
 */
bool Directory::doIncludeFilename() const
{
  return  m_includesFilename;
}

/**
 * Sets if the last entry is a filename
 * @return
 */
void Directory::setIncludeFilename( bool doInclude )
{
  m_includesFilename  = doInclude;
}

/**
 * true if the directory is a relative directory.
 * @return
 */
bool Directory::isRelative() const
{
  return  m_relativePath;
}

/**
 * Sets if the directory should be a relative directory.
 * @param isRelative
 */
void Directory::setRelative( bool isRelative )
{
  m_relativePath  = isRelative;
}
