/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef DIRECTORY_H_
#define DIRECTORY_H_

#include  <string>
#include  <list>
#include  <cstdlib>
#include <sys/stat.h>
#include <sys/types.h>

using namespace std;

/**
 * @class Directory
 * @brief contains a directory name
 *
 * It can also create the directory with or without the last directory
 * entry (when used as filename).
 */
class Directory
{
  private:
    list<string>    m_dir;
    bool            m_includesFilename;
    bool            m_relativePath;

    void parseDir( string dir );
    void appendDirectory( string& path, list<string>::const_iterator& dir ) const;

  public:
    Directory();
    Directory( bool isRelative );
    Directory( string dir, bool includesFilename );

    void createDirectory() const;
    string getDirectory() const;

    const list<string> getBrokenDirectory() const;

    void addSubdirectory( string name );

    bool doIncludeFilename() const;
    void setIncludeFilename( bool doInclude );
    bool isRelative() const;
    void setRelative( bool isRelative );

};

#endif /* DIRECTORY_H_ */
