/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

#include  "convert.h"

/**
 * Converts a string to a double
 * @param val
 * @return
 */
double strToFloat( string val )
{
  stringstream  sstr;
  double        result;

  if( val == "nan" )   //TODO: is there a better way to do this?
  {
    return  NAN;
  }

  sstr << val;
  sstr >> result;

  return  result;
}

/**
 * Converts a string to a int
 * @param val
 * @return
 */
int strToInt( string val )
{
  stringstream  sstr;
  int           result;

  sstr << val;
  sstr >> result;

  return  result;
}

/**
 * Converts a int to a string
 * @param val
 * @return
 */
string intToStr( int val )
{
  stringstream  sstr;
  string        result;

  sstr << val;
  sstr >> result;

  return  result;
}

/**
 * Converts a double to a string
 * @param val
 * @return
 */
string floatToStr( double val )
{
  stringstream  sstr;
  string        result;

  sstr << val;
  sstr >> result;

  return  result;
}

