/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * @file types.h
 *
 */

#ifndef TYPES_H_
#define TYPES_H_

#include <map>
#include <string>

/**
 * The Range of an parameter.
 * Defines the minimum and maximum values a parameter can contain.
 */
struct RangeS{
	double minimum;
	double maximum;
};


/**
 * Map of parameters (string) and their range (RangeS).
 * @see RangeS
 */
typedef std::map<std::string,RangeS> MapParameterToRangeT;


/**
 * Map of parameters (string) and their values (double).
 */
typedef std::map<std::string,double> MapParameterToValueT;

#endif /* TYPES_H_ */
