/*
    Copyright 2009 Nicolas Rüegg, Urs Fässler


    This file is part of Vidyaa.

    Vidyaa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Vidyaa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Vidyaa.  If not, see <http://www.gnu.org/licenses/>.
*/


#include  "paramutils.h"

/*MapParameterToValueT valueMerge( const MapParameterToValueT& base, const MapParameterToValueT& additional )
{
  MapParameterToValueT                    result;
  MapParameterToValueT::const_iterator    itr;

  result  = base;

//  result.insert( additional.begin(), additional.end() );
  for( itr = additional.begin(); itr != additional.end(); itr++ )
  {
    result[itr->first]  = itr->second;
  }

  return  result;
}*/

/**
 * Serialize the map to the stream.
 * @param map
 * @param stream
 */
void serializeMap( const MapParameterToValueT& map, ostream& stream )
{
  MapParameterToValueT::const_iterator    itr;

  for( itr = map.begin(); itr != map.end(); itr++ )
  {
    stream << itr->first << " " << itr->second << endl;
  }
}

/**
 * Parse the name and values and adds to the map.
 * @param map
 * @param stream
 */
void deserializeMap( MapParameterToValueT& map, istream& stream )
{
  while( !( stream.eof() ) )
  {
    string    name;
    string    value;

    stream >> name >> ws >> value >> ws;

    map[name]  = strToFloat( value );
  }
}

